"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeStateTrieProof = exports.maybeAddProofNode = exports.makeMerkleTreeProof = void 0;
const core_utils_1 = require("@eth-optimism/core-utils");
const ethers_1 = require("ethers");
const merkletreejs_1 = require("merkletreejs");
const rlp = __importStar(require("rlp"));
const makeMerkleTreeProof = (leaves, index) => {
    const correctedTreeSize = Math.pow(2, Math.ceil(Math.log2(leaves.length)));
    const parsedLeaves = [];
    for (let i = 0; i < correctedTreeSize; i++) {
        if (i < leaves.length) {
            parsedLeaves.push(leaves[i]);
        }
        else {
            parsedLeaves.push(ethers_1.ethers.utils.keccak256('0x' + '00'.repeat(32)));
        }
    }
    const bufLeaves = parsedLeaves.map(core_utils_1.fromHexString);
    const tree = new merkletreejs_1.MerkleTree(bufLeaves, (el) => {
        return (0, core_utils_1.fromHexString)(ethers_1.ethers.utils.keccak256(el));
    });
    const proof = tree.getProof(bufLeaves[index], index).map((element) => {
        return (0, core_utils_1.toHexString)(element.data);
    });
    return proof;
};
exports.makeMerkleTreeProof = makeMerkleTreeProof;
const maybeAddProofNode = (key, proof) => {
    const modifiedProof = [...proof];
    const finalProofEl = modifiedProof[modifiedProof.length - 1];
    const finalProofElDecoded = rlp.decode(finalProofEl);
    if (finalProofElDecoded.length === 17) {
        for (const item of finalProofElDecoded) {
            if (Array.isArray(item)) {
                const suffix = (0, core_utils_1.toHexString)(item[0]).slice(3);
                if (key.endsWith(suffix)) {
                    modifiedProof.push((0, core_utils_1.toHexString)(rlp.encode(item)));
                }
            }
        }
    }
    return modifiedProof;
};
exports.maybeAddProofNode = maybeAddProofNode;
const makeStateTrieProof = async (provider, blockNumber, address, slot) => {
    const proof = await provider.send('eth_getProof', [
        address,
        [slot],
        (0, core_utils_1.toRpcHexString)(blockNumber),
    ]);
    proof.storageProof[0].proof = (0, exports.maybeAddProofNode)(ethers_1.ethers.utils.keccak256(slot), proof.storageProof[0].proof);
    return {
        accountProof: proof.accountProof,
        storageProof: proof.storageProof[0].proof,
        storageValue: ethers_1.BigNumber.from(proof.storageProof[0].value),
        storageRoot: proof.storageHash,
    };
};
exports.makeStateTrieProof = makeStateTrieProof;
//# sourceMappingURL=merkle-utils.js.map